import os
import aiosmtplib
from email.message import EmailMessage
from dotenv import load_dotenv

load_dotenv()

SMTP_HOST = os.getenv("SMTP_HOST")
SMTP_PORT = int(os.getenv("SMTP_PORT"))
SMTP_USER = os.getenv("SMTP_USER")
SMTP_PASS = os.getenv("SMTP_PASS")
ADMIN_EMAIL = os.getenv("ADMIN_EMAIL")

def load_email_template(template_path: str, context: dict) -> str:
    with open(template_path, "r", encoding="utf-8") as file:
        template = file.read()
    for key, value in context.items():
        template = template.replace(f"{{{{{key}}}}}", value)
    return template


async def send_contact_email(name, email, phone, message):
    content = load_email_template("templates/contact_email_template.html", {
        "name": name,
        "email": email,
        "phone": phone,
        "message": message
    })

    msg = EmailMessage()
    msg["From"] = SMTP_USER
    msg["To"] = ADMIN_EMAIL
    msg["Subject"] = f"New Contact Message from {name}"
    msg.set_content("This is an HTML email. Please view it in an HTML-compatible client.")
    msg.add_alternative(content, subtype="html")

    await aiosmtplib.send(
        msg,
        hostname=SMTP_HOST,
        port=SMTP_PORT,
        start_tls=False,
        use_tls=False,
        username=SMTP_USER,
        password=SMTP_PASS,
    )


    