from sqlalchemy.orm import Session
import models, schemas
from auth_utils import hash_password, verify_password

def create_user(db: Session, user: schemas.UserCreate):
    hashed = hash_password(user.password)
    db_user = models.User(name=user.name, email=user.email, hashed_password=hashed)
    db.add(db_user)
    db.commit()
    db.refresh(db_user)
    return db_user

def authenticate_user(db: Session, email: str, password: str):
    user = db.query(models.User).filter(models.User.email == email).first()
    if user and verify_password(password, user.hashed_password):
        return user
    return None

def submit_contact(db: Session, contact: schemas.ContactCreate):
    db_contact = models.ContactUs(**contact.dict())
    db.add(db_contact)
    db.commit()
    db.refresh(db_contact)
    return db_contact

# Banner
def create_banner(db: Session, banner: schemas.BannerCreate):
    db_banner = models.Banner(**banner.dict())
    db.add(db_banner)
    db.commit()
    db.refresh(db_banner)
    return db_banner

def get_banners(db: Session):
    return db.query(models.Banner).all()

def delete_banner(db: Session, banner_id: int):
    banner = db.query(models.Banner).get(banner_id)
    if banner:
        db.delete(banner)
        db.commit()

# Gallery
def create_gallery(db: Session, gallery: schemas.GalleryCreate):
    db_gallery = models.Gallery(**gallery.dict())
    db.add(db_gallery)
    db.commit()
    db.refresh(db_gallery)
    return db_gallery

def get_gallery(db: Session):
    return db.query(models.Gallery).all()

def delete_gallery(db: Session, gallery_id: int):
    gallery = db.query(models.Gallery).get(gallery_id)
    if gallery:
        db.delete(gallery)
        db.commit()



def create_service(db: Session, service: schemas.ServiceCreate):
    db_service = models.Service(**service.dict())
    db.add(db_service)
    db.commit()
    db.refresh(db_service)
    return db_service

def get_services(db: Session):
    return db.query(models.Service).all()

def get_service(db: Session, service_id: int):
    return db.query(models.Service).filter(models.Service.id == service_id).first()

def update_service(db: Session, service_id: int, update_data: schemas.ServiceUpdate):
    service = get_service(db, service_id)
    if service:
        service.title = update_data.title
        service.description = update_data.description
        db.commit()
        db.refresh(service)
    return service

def delete_service(db: Session, service_id: int):
    service = get_service(db, service_id)
    if service:
        db.delete(service)
        db.commit()
    return service

